<?php

namespace App\Http\Controllers;

use App\Models\Notice;
use App\Models\Studentregistration;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Notification;
use App\Notifications\NoticeBoard;

class NoticeController extends Controller
{
   /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
    **/
    public function index()
    {
        $id= 1;
        $studentnotice= Notice::orderBy('id','desc')->paginate(10);
        return view('backend.notice.index', compact('studentnotice','id'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.notice.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string',
            'date' => 'required',
            'notice' => 'required|string',
        ]);

        $studentnotice = new Notice();
        $studentnotice->title = $request->title;
        $studentnotice->date = $request->date;
        $studentnotice->notice = $request->notice;
        $studentnotice->save();

        return back()->with('success','Notice Created Successful');
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $studentnotice = Notice::find($id);
        return view('backend.notice.edit', compact('studentnotice'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'title' => 'required|string',
            'date' => 'required',
            'notice' => 'required|string',
        ]);

        $studentnotice = Notice::find($id);
        $studentnotice->title = $request->title;
        $studentnotice->date = $request->date;
        $studentnotice->notice = $request->notice;
        $studentnotice->save();

        return back()->with('success','Notice Updated Successful');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        $studentnotice= Notice::find($id);
        $studentnotice->delete();

        return back()->with('success','Notice Deleted Successful');
    }
}
