@extends('layouts.backend')
@section('mainContent')
   <main>
    <div class="container-fluid">
        <ol class="breadcrumb my-4">
            <li class="breadcrumb-item active">All Notice Here</li>
        </ol>
      {{-- session show     --}}
      @if (Session::has('success'))
      <p class="text-success">{{session('success')}}</p>
      @endif

      <div class="card mb-4">
         <div class="card-header">
            <a class="btn btn-dark sm-btn" href="{{route('CreateStudentNotice')}}" >Add Notice</a>
         </div>
         <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>SI</th>
                            <th>Date</th>
                            <th>Notice</th>
                            <th>Action</th>
                        </tr>
                    </thead>

                    <tbody>
                        @if (count($studentnotice)>0)
                          @foreach ($studentnotice as $item)
                            <tr>
                                <td>{{$id++}}</td>
                                <td>{{ $item->date}}</td>
                                <td>{{ Str::limit(strip_tags($item->notice), 100) }}</td>
                                <td>
                                    <a class="btn btn-success sm-btn" href="{{route('EditStudentNotice', $item->id)}}" >Edit</a>
                                    <a class="btn btn-danger sm-btn" href="{{route('DeleteStudentNotice', $item->id)}}" >Delete</a>
                                </td>
                            </tr>
                          @endforeach
                        @endif

                    </tbody>
                </table>
            </div>
         </div>
       </div>
    </div>
   </main>
@endsection
