<?php

namespace App\Http\Controllers;

use App\Models\Course;
use Illuminate\Http\Request;

class CourseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $id= 1;
        $studentcourse= Course::paginate(8);
         return view('backend.course.index', compact('studentcourse','id'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.course.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
            $request->validate([
                'course'=> 'required|string|max:200',
            ]);

            $studentcourse= new Course();
            $studentcourse->course = $request->course;
            $studentcourse->save();

            return back()->with('success','Course Create Successful');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $studentcourse = Course::find($id);
        return view('backend.course.edit', compact('studentcourse'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'course'=> 'required|string|max:200',
        ]);

        $studentcourse= Course::find($id);
        $studentcourse->course = $request->course;
        $studentcourse->save();

        return back()->with('success','Course Update Successful');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $studentcourse= Course::find($id);
        $studentcourse->delete();

        return back()->with('success','Course Delete Successful');
    }
}
